clear
close all
tic

Position=[200 200 900 800];
TitleSz=24; LblSz=20; AxSz=16;
NL=sprintf('\n');

% load Data
load compress_steel

X=Xdat(end,:);
Y=Ydat(end,:);
Z=Zdat(end,:);

Xdat2=Xdat;
Ydat2=Ydat;
Zdat2=Zdat;
for ii=1:N
    Xdat2(:,ii)=Xdat2(:,ii)-((Xdat2(1,ii)));
    Ydat2(:,ii)=Ydat2(:,ii)-((Ydat2(1,ii)));
    Zdat2(:,ii)=Zdat2(:,ii)-((Zdat2(1,ii)));
end

Poisson=(Ey/(2*G))-1;

exagY=1;
exag=2e1;
exagstr='(20) ';
matstr='Steel';

Xe=Xdat(1,:)+(Xdat2(end,:)*exag);
Ye=Ydat(1,:)+(Ydat2(end,:)*exagY);
Ze=Zdat(1,:)+(Zdat2(end,:)*exag);

dtplot=(TimeFct(:,1)); dt=max(diff(TimeFct)); dx=median(dx);
height=max(X0(:,2))-min(X0(:,2))+dx;
width=max(X0(:,1))-min(X0(:,1))+dx;

ff=find(X0(:,2)==max(X0(:,2))); 
Tcalc=Ey*max(Ydat2(:,:)')/height;
Tavg=max(abs(T22(:,ff)'));


YY=zeros(1,N);
for ii=2:(N-1)
    YY(ii)=(abs(Y(ii)-Y(ii-1))-dx)+(abs(Y(ii)-Y(ii+1))-dx);
    YY(ii)=YY(ii)*Ey/dx;
end
ratio=max(T22').*((min(T22').^-1)); ratio=ratio-1;



PoissonError=100*abs((Poisson/((max(abs(Xdat2(ct,:)))/width)/(max(abs(Ydat2(ct,:)))/height)))-1);
TensionError = 100*abs((Tcalc(ct)/Tavg(ct))-1);

MaxStress=abs(Tavg(ct));

dxmat=(max(X0(:,2))-min(X0(:,2)))/20;
axismat=[(min(Xe)-dxmat) (max(Xe)+dxmat) (min(Ye)-dxmat) (max(Ye)+dxmat)];

TCstr='Compression'; 
MaxStressStr=[num2str(MaxStress*(1e-6)) ' MPa'];

TitleStr=[matstr ' - Max Stress = ' MaxStressStr 10];

figure(1)
set(gcf,'Position',Position)
set(0,'DefaultAxesFontSize',AxSz,'DefaultAxesFontWeight','b')
hold off
for ii=1:N
    if Fixed(ii)==0
        plot(Xe(ii),Ye(ii),'ko','LineWidth',4)
        hold on
    else
        plot(Xe(ii),Ye(ii),'kx','LineWidth',4)
        hold on
        
    end
end
axis(axismat)
title([TitleStr 'Exaggerated ' exagstr TCstr],'fontsize',TitleSz,'fontweight','b');
xlabel('X','fontsize',LblSz,'fontweight','b');
ylabel('Y','fontsize',LblSz,'fontweight','b');

figure(2)
set(gcf,'Position',Position)
set(0,'DefaultAxesFontSize',AxSz,'DefaultAxesFontWeight','b')
hold off
for ii=1:N
    if Fixed(ii)==0
        plot(Xdat(1,ii),Ydat(1,ii),'ko','LineWidth',4)
        hold on
    else
        plot(Xdat(1,ii),Ydat(1,ii),'kx','LineWidth',4)
        hold on
        
    end
end
axis(axismat)
title([TitleStr 'Before ' TCstr],'fontsize',TitleSz,'fontweight','b');
xlabel('X','fontsize',LblSz,'fontweight','b');
ylabel('Y','fontsize',LblSz,'fontweight','b');





%fprintf(['\n']);
display(' ');
display(['Poisson Error = ' num2str(PoissonError) '%']);    
display(['Tension Error = ' num2str(TensionError) '%']);    
display(' ');

%close all

toc